<?php
/**
 * @ Chess League Manager (CLM) Component 
 * @Copyright (C) 2008 Thomas Schwietert & Andreas Dorn. All rights reserved
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fishpoke.de
 * @author Thomas Schwietert
 * @email fishpoke@fishpoke.de
 * @author Andreas Dorn
 * @email webmaster@sbbl.org
*/

defined('_JEXEC') or die();
jimport('joomla.application.component.model');

class CLMModelStatistik extends JModel
{

	function _getCLMLiga( &$options )
	{
	$sid	= JRequest::getInt('saison','1');
	$lid	= JRequest::getInt('liga','1');
	$db	= JFactory::getDBO();
	$id	= @$options['id'];
 
	$query = " SELECT a.name, a.stamm, a.teil FROM #__clm_liga as a"
		." LEFT JOIN #__clm_saison as s ON s.id = a.sid "
		." WHERE a.id = $lid AND a.sid = $sid "
		." AND s.published = 1"
		;
	return $query;
	}

	function getCLMLiga( $options=array() )
	{
		$query	= $this->_getCLMLiga( $options );
		$result = $this->_getList( $query );
		return @$result;
	}

	function getCLMSchwarz( $options=array() )
	{
		$query	= $this->_getCLMSchwarz( $options );
		$result = $this->_getList( $query );
		return @$result;
	}

	function _getCLMRemis( &$options )
	{
	$sid = JRequest::getInt('saison','1');
	$lid = JRequest::getInt('liga','1');	
		$db			= JFactory::getDBO();
		$id			= @$options['id'];
 
		$query = " SELECT COUNT(id) as remis FROM #__clm_rnd_spl"
			." WHERE weiss = 1 AND ergebnis = 2 AND sid = $sid AND lid = $lid "
			;

		return $query;
	}

	function getCLMRemis( $options=array() )
	{
		$query	= $this->_getCLMRemis( $options );
		$result = $this->_getList( $query );
		return @$result;
	}

	function _getCLMKampflos( &$options )
	{
	$sid = JRequest::getInt('saison','1');
	$lid = JRequest::getInt('liga','1');	
		$db			= JFactory::getDBO();
		$id			= @$options['id'];
 
		$query = " SELECT COUNT(id) as kampflos FROM #__clm_rnd_spl"
			." WHERE weiss = 1 AND ergebnis > 2 AND sid = $sid AND lid = $lid "
			;

		return $query;
	}

	function getCLMKampflos( $options=array() )
	{
		$query	= $this->_getCLMKampflos( $options );
		$result = $this->_getList( $query );
		return @$result;
	}

	function _getCLMHeim( &$options )
	{
	$sid = JRequest::getInt('saison','1');
	$lid = JRequest::getInt('liga','1');	
		$db			= JFactory::getDBO();
		$id			= @$options['id'];
 
		$query = " SELECT brett,SUM(punkte) as sum FROM #__clm_rnd_spl "
			." WHERE sid = $sid AND heim = 1 AND lid = $lid "
			." GROUP BY sid "
			;

		return $query;
	}

	function getCLMHeim( $options=array() )
	{
		$query	= $this->_getCLMHeim( $options );
		$result = $this->_getList( $query );
		return @$result;
	}

	function _getCLMGast( &$options )
	{
	$sid = JRequest::getInt('saison','1');
	$lid = JRequest::getInt('liga','1');	
		$db			= JFactory::getDBO();
		$id			= @$options['id'];
 
		$query = " SELECT brett,SUM(punkte) as sum FROM #__clm_rnd_spl "
			." WHERE sid = $sid AND heim = 0 AND lid = $lid "
			." GROUP BY sid "
			;

		return $query;
	}

	function getCLMGast( $options=array() )
	{
		$query	= $this->_getCLMGast( $options );
		$result = $this->_getList( $query );
		return @$result;
	}

	function _getCLMGesamt( &$options )
	{
	$sid = JRequest::getInt('saison','1');
	$lid = JRequest::getInt('liga','1');	
		$db			= JFactory::getDBO();
		$id			= @$options['id'];
 
		$query = " SELECT COUNT(id) as gesamt FROM #__clm_rnd_spl"
			." WHERE weiss = 1 AND sid = $sid AND lid = $lid "
			;

		return $query;
	}

	function getCLMGesamt( $options=array() )
	{
		$query	= $this->_getCLMGesamt( $options );
		$result = $this->_getList( $query );
		return @$result;
	}

	function _getCLMSpieler( &$options )
	{
	$sid = JRequest::getInt('saison','1');
	$lid = JRequest::getInt('liga','1');	
		$db			= JFactory::getDBO();
		$id			= @$options['id'];
 
		$query = " SELECT a.lid,a.mnr,a.mgl_nr,a.zps,a.Punkte,a.Partien,a.Niveau,a.Leistung, d.ZPS,d.DWZ,d.Spielername,v.Vereinname "
			." FROM #__clm_meldeliste_spieler as a"
			." LEFT JOIN #__clm_dwz_spieler as d ON d.ZPS = a.zps AND d.Mgl_Nr = a.mgl_nr AND d.sid = a.sid"
			." LEFT JOIN #__clm_dwz_vereine as v ON v.ZPS = a.zps AND v.sid = a.sid"
			." WHERE a.lid = $lid "
			." AND a.sid = ".$sid
			." GROUP BY a.zps, a.mgl_nr "
			//." ORDER BY a.Punkte DESC, a.Partien ASC, a.Niveau DESC LIMIT 10"
			." ORDER BY a.Leistung DESC, a.Punkte DESC, a.Partien ASC, a.Niveau DESC LIMIT 10"
			;

		return $query;
	}

	function getCLMSpieler( $options=array() )
	{
		$query	= $this->_getCLMSpieler( $options );
		$result = $this->_getList( $query );
		return @$result;
	}

	function _getCLMBestenliste( &$options )
	{
	global $mainframe, $option;
	$sid = JRequest::getInt('saison','1');
	$lid = JRequest::getInt('liga','1');	
		$db			= JFactory::getDBO();
		$id			= @$options['id'];
 
		$query = " SELECT DISTINCT a.Partien,a.lid,a.mnr,a.snr,a.mgl_nr,a.zps,a.Punkte,a.Niveau,a.Leistung, d.ZPS,d.DWZ,d.Spielername,v.Vereinname "
			." FROM #__clm_meldeliste_spieler as a"
			." LEFT JOIN #__clm_dwz_spieler as d ON d.ZPS = a.zps AND d.Mgl_Nr = a.mgl_nr AND d.sid = a.sid"
			." LEFT JOIN #__clm_dwz_vereine as v ON v.ZPS = a.zps AND v.sid = a.sid"
			." WHERE a.lid = $lid AND a.Partien != 0"
			." AND a.sid = ".$sid
			;

		$filter_order     = $mainframe->getUserStateFromRequest( $option.'filter_order_bl', 'filter_order', 'Punkte', 'cmd' );
		$filter_order_Dir = $mainframe->getUserStateFromRequest( $option.'filter_order_Dir_bl', 'filter_order_Dir', '', 'word' );
			
		if(!empty($filter_order) && !empty($filter_order_Dir) ){
			$query .= ' ORDER BY '.$filter_order.' '.$filter_order_Dir .', a.Punkte DESC, a.Partien ASC, a.Niveau DESC';
		} else {
			$query .= ' ORDER BY  a.Leistung DESC, a.Punkte DESC, a.Partien ASC, a.Niveau DESC';
		}
		
		return $query;
	}

	function getCLMBestenliste( $options=array() )
	{
		$query	= $this->_getCLMBestenliste( $options );
		$result = $this->_getList( $query );
		return @$result;
	}

	function checkSpieler( $punkte )
	{
	$sid = JRequest::getInt('saison','1');
	$lid = JRequest::getInt('liga','1');	
		$db			= JFactory::getDBO();
		$id			= @$options['id'];
 
		$query = " SELECT COUNT(lid) as id FROM #__clm_meldeliste_spieler "
			." WHERE Punkte = $punkte AND lid = $lid "
			;
		$db->setQuery( $query);
		$count	= $db->loadObjectList();
		$anzahl = $count[0]->id;

		return $anzahl;
	}

	function _getCLMMannschaft( &$options )
	{
	$lid	= JRequest::getInt('liga','1');
	$sid	= JRequest::getInt('saison','1');
	$db	= JFactory::getDBO();
	$id	= @$options['id'];
 
		$query = " SELECT a.tln_nr,l.name as liga,l.stamm,m.name, COUNT(a.id) as count, SUM(manpunkte) as mp, SUM(brettpunkte) as bp"
			." FROM #__clm_rnd_man as a "
			." LEFT JOIN #__clm_liga as l ON  l.id = a.lid AND l.sid = a.sid "
			." LEFT JOIN #__clm_mannschaften as m ON  m.liga = a.lid AND m.tln_nr = a.tln_nr AND m.sid = a.sid "
			//." WHERE a.heim = 1 "
			." WHERE a.manpunkte > -1 AND lid = $lid "
			." AND a.sid = ".$sid
			." GROUP BY a.lid,a.tln_nr "
			." ORDER BY mp DESC, bp DESC "
			." LIMIT 20 "
			;

		return $query;
	}

	function getCLMMannschaft( $options=array() )
	{
		$query	= $this->_getCLMMannschaft( $options );
		$result = $this->_getList( $query );
		return @$result;
	}

	function Bretter()
	{
	$sid = JRequest::getInt('saison','1');
	$lid = JRequest::getInt('liga','1');	
		$db			= JFactory::getDBO();
		$id			= @$options['id'];
 
		$query = " SELECT stamm FROM #__clm_liga "
			." WHERE sid =$sid AND id = $lid "
			." ORDER BY stamm DESC LIMIT 1"
			;
		$db->setQuery( $query);
		$count	= $db->loadObjectList();
		$anzahl = $count[0]->stamm;

		return $anzahl;
	}

	function _getCLMBrett( &$options )
	{
	$sid = JRequest::getInt('saison','1');
	$lid = JRequest::getInt('liga','1');
		$db			= JFactory::getDBO();
		$id			= @$options['id'];
 
		$query = " SELECT brett,SUM(punkte) as sum, COUNT(id) as count FROM #__clm_rnd_spl "
			." WHERE sid = $sid AND heim = 1 AND lid = $lid AND `gemeldet` != 0"
			." GROUP BY brett "
			." ORDER BY brett ASC  "
			;

		return $query;
	}

	function getCLMBrett( $options=array() )
	{
		$query	= $this->_getCLMBrett( $options );
		$result = $this->_getList( $query );
		return @$result;
	}

	function _getCLMWBrett( &$options )
	{
	$sid = JRequest::getInt('saison','1');
	$lid = JRequest::getInt('liga','1');
		$db			= JFactory::getDBO();
		$id			= @$options['id'];
 
		$query = " SELECT brett,COUNT(id) as sum FROM #__clm_rnd_spl "
			." WHERE sid = $sid AND heim = 1 AND lid = $lid "
			." AND ergebnis = 0"
			." GROUP BY brett "
			." ORDER BY brett ASC  "
			;

		return $query;
	}

	function CLMBrett_all( $bretter )
	{
	$sid = JRequest::getInt('saison','1');
	$lid = JRequest::getInt('liga','1');
		$db			= JFactory::getDBO();

// wg
		$query = " SELECT brett,COUNT(id) as sum FROM #__clm_rnd_spl "
			." WHERE sid = $sid AND heim = 1 AND lid = $lid "
			//." AND weiss = 0 AND ergebnis = 1"
			." AND weiss = 1 AND ergebnis = 1"		//klkl
			." GROUP BY brett "
			." ORDER BY brett, dg, runde, paar "
			;
	$db->setQuery( $query);
	$wg= $db->loadObjectList();
// wu
		$query = " SELECT brett,COUNT(id) as sum FROM #__clm_rnd_spl "
			." WHERE sid = $sid AND heim = 1 AND lid = $lid "
			//." AND weiss = 1 AND ergebnis = 0"
			." AND weiss = 0 AND ergebnis = 0"		//klkl
			." GROUP BY brett "
			." ORDER BY brett, dg, runde, paar "
			;
	$db->setQuery( $query);
	$wu= $db->loadObjectList();
// sg
		$query = " SELECT brett,COUNT(id) as sum FROM #__clm_rnd_spl "
			." WHERE sid = $sid AND heim = 1 AND lid = $lid "
			//." AND weiss = 0 AND ergebnis = 0"
			." AND weiss = 1 AND ergebnis = 0"		//klkl
			." GROUP BY brett "
			." ORDER BY brett, dg, runde, paar "
			;
	$db->setQuery( $query);
	$sg= $db->loadObjectList();
// su
		$query = " SELECT brett,COUNT(id) as sum FROM #__clm_rnd_spl "
			." WHERE sid = $sid AND heim = 1 AND lid = $lid "
			//." AND weiss = 1 AND ergebnis = 1"
			." AND weiss = 0 AND ergebnis = 1"		//klkl
			." GROUP BY brett "
			." ORDER BY brett, dg, runde, paar "
			;
	$db->setQuery( $query);
	$su= $db->loadObjectList();

	$wgc = 0;
	$wuc = 0;
	$sgc = 0;
	$suc = 0;


	for ($x=1; $x < (1+$bretter); $x++) {

	  $sum_weiss	= 0;
	  $sum_schwarz	= 0;

	// ungerades Brett
	  //if  ($x%2 == 0) {		
	  if  ($x%2 !== 0) {		//klkl
	    if($wu[$wuc]->brett == $x) { $sum_weiss = $wu[$wuc]->sum; $wuc++;}
	    if($su[$suc]->brett == $x) { $sum_schwarz = $su[$suc]->sum; $suc++;}

	// gerades Brett
	    } else {
	    if($wg[$wgc]->brett == $x) { $sum_weiss = $wg[$wgc]->sum; $wgc++;}
	    if($sg[$sgc]->brett == $x) { $sum_schwarz = $sg[$sgc]->sum; $sgc++;}
		}

		$all[] = array('w' => "$sum_weiss", 's' => "$sum_schwarz");
		}
		return $all;
	}


	function _getCLMRBrett( &$options )
	{
	$sid = JRequest::getInt('saison','1');
	$lid = JRequest::getInt('liga','1');
		$db			= JFactory::getDBO();
		$id			= @$options['id'];
 
		$query = " SELECT brett,COUNT(id) as sum FROM #__clm_rnd_spl "
			." WHERE sid = $sid AND heim = 1 AND lid = $lid "
			." AND ergebnis = 2"
			." GROUP BY brett "
			." ORDER BY brett ASC  "
			;

		return $query;
	}

	function getCLMRBrett( $options=array() )
	{
		$query	= $this->_getCLMRBrett( $options );
		$result = $this->_getList( $query );
		return @$result;
	}

	function _getCLMKBrett( &$options )
	{
	$sid = JRequest::getInt('saison','1');
	$lid = JRequest::getInt('liga','1');
		$db			= JFactory::getDBO();
		$id			= @$options['id'];
 
		$query = " SELECT brett,COUNT(id) as sum FROM #__clm_rnd_spl "
			." WHERE sid = $sid AND weiss = 1 AND lid = $lid "
			//." WHERE sid = $sid AND heim = 1 AND lid = $lid "
			." AND `ergebnis` > 2"
			//." AND `kampflos` != 0"
			." GROUP BY brett "
			." ORDER BY brett ASC  "
			;

		return $query;
	}

	function getCLMKBrett( $options=array() )
	{
		$query	= $this->_getCLMKBrett( $options );
		$result = $this->_getList( $query );
		return @$result;
	}


}
?>
